/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation;

import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import com.mojang.math.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ModelPartAnimationContext {
    private final int initialTick;
    private final int totalTicks;
    private int currentTick;
    private final Vector3f targetVector;
    private final Vector3f currentVector;
    private float progress;

    private ModelPartAnimationContext(int initialTick, int totalTicks, float progress, Vector3f targetVector, Vector3f currentVector) {
        this.initialTick = initialTick;
        this.totalTicks = totalTicks;
        this.currentTick = initialTick;
        this.progress = progress;
        this.targetVector = targetVector;
        this.currentVector = currentVector;
    }

    public static ModelPartAnimationContext createWithTicks(int initialTick, int totalTicks, Vector3f targetVector, Vector3f currentVector) {
        return new ModelPartAnimationContext(initialTick, totalTicks, 0.0f, targetVector, currentVector);
    }

    public static ModelPartAnimationContext createWithProgress(float progress, Vector3f targetVector, Vector3f currentVector) {
        return new ModelPartAnimationContext(0, 0, progress, targetVector, currentVector);
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public void recalculateProgress() {
        float progress = (float)(this.currentTick - this.initialTick) / (float)this.totalTicks;
        this.progress = Math.min(Math.max(-1.0f, progress), 1.0f);
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public Vector3f getCurrentVector() {
        return this.currentVector;
    }

    public Vector3f getTargetVector() {
        return this.targetVector;
    }

    public void recalculateCurrentVector() {
        this.currentVector.m_122245_(this.recalculateCurrentX(), this.recalculateCurrentY(), this.recalculateCurrentZ());
    }

    private float recalculateCurrentX() {
        return this.calculateNewValue(this.currentVector.m_122239_(), this.targetVector.m_122239_());
    }

    private float recalculateCurrentY() {
        return this.calculateNewValue(this.currentVector.m_122260_(), this.targetVector.m_122260_());
    }

    private float recalculateCurrentZ() {
        return this.calculateNewValue(this.currentVector.m_122269_(), this.targetVector.m_122269_());
    }

    private float calculateNewValue(float currentValue, float targetValue) {
        return AnimationMath.lerp(this.progress, currentValue, targetValue);
    }
}

